using System;
using System.Data;
using System.Data.SqlClient;
using System.Reflection;
using gov.va.med.vbecs.ExceptionManagement;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.DAL
{


	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Cameron Taylor</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>10/13/2002</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	/// AntibodyType data access layer static class.
	///</summary>

	#endregion
	
	public class AntibodyType 
	{

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/13/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="785"> 
		///		<ExpectedInput>AntibodyTypeId</ExpectedInput>
		///		<ExpectedOutput>The data table containing antibodies</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="786"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetAntibodyType - returns a DataTable of AntiBody information for the AntibodyId
		/// </summary>
		/// <param name="antibodyTypeId"></param>
		/// <returns></returns>
		public static DataTable GetAntibodyType( int antibodyTypeId )
		{
			SqlParameter _prm = new SqlParameter( STOREDPROC.GetAntibodyType.antibodytypeid, SqlDbType.Int );
			_prm.Value = antibodyTypeId;

			return StoredProcedure.GetDataTable( STOREDPROC.GetAntibodyType.StoredProcName, _prm );			
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/13/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="635"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>The data table containing antibodies</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="787"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>		
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Static function to retrieve a list of all antibody types available for 
		/// certain division for display
		/// </summary>
		/// <returns>Data table containing antibody type list</returns>
		public static DataTable GetAntibodyTypeLookupList()
		{
			SqlParameter _prm = new SqlParameter( STOREDPROC.GetAntibodyTypeLookupList.divisioncode, System.Data.SqlDbType.VarChar );
			_prm.Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetDataTable( STOREDPROC.GetAntibodyTypeLookupList.StoredProcName, _prm );
		}


		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7316"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataTable</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7317"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetCompleteAntibodyTypeList
		/// </summary>
		/// <returns></returns>
		public static DataTable GetCompleteAntibodyTypeList()
		{
			return StoredProcedure.GetDataTable( STOREDPROC.GetCompleteAntibodyTypeList.StoredProcName);
		}
		


		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7318"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataTable</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="7319"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Static function to retrieve a list of all antibody types not including antigen information 
		/// available for certain division for display
		/// </summary>
		/// <returns>Data table containing antibody type list</returns>
		public static DataTable GetAntibodiesWithoutAntigens()
		{
			SqlParameter _prm = new SqlParameter( STOREDPROC.GetAntibodiesWithoutAntigens.divisioncode, System.Data.SqlDbType.VarChar );
			_prm.Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetDataTable( STOREDPROC.GetAntibodiesWithoutAntigens.StoredProcName, _prm );
		}
		
		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/13/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="788"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>The data table containing AntibodyTypes</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="789"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>		
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetAntibodyType
		/// </summary>
		/// <returns>Data table</returns>
		public static DataTable GetAntibodyType()
		{
			return StoredProcedure.GetDataTable( STOREDPROC.GetAntibodyTypeList.StoredProcName );
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/13/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="790"> 
		///		<ExpectedInput>Int</ExpectedInput>
		///		<ExpectedOutput>The data table containing the AntibodyType</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="791"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>		
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetAntibodyParameterByID
		/// </summary>
		/// <param name="antibodyTypeId">AntibodyTypeId of the Parameter to fetch</param>
		/// <returns>Data table</returns>
		public static DataTable GetAntibodyParameterById(int antibodyTypeId)
		{
			SqlParameter[] _prms = 
					{
						new SqlParameter(STOREDPROC.GetAntibodyParameterByID.divisioncode, System.Data.SqlDbType.VarChar),
						new SqlParameter(STOREDPROC.GetAntibodyParameterByID.antibodytypeid, System.Data.DbType.Int16)
					};

			_prms[0].Value = Common.LogonUser.LogonUserDivisionCode;
			_prms[1].Value = antibodyTypeId;

			return StoredProcedure.GetDataTable( STOREDPROC.GetAntibodyParameterByID.StoredProcName, _prms );
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1152"> 
		///		<ExpectedInput>Antibody identifier and division code</ExpectedInput>
		///		<ExpectedOutput>The data table containing blood units</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1880"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets the list of blood units with the certain antibody type for the
		/// division with specified division code. 
		/// </summary>
		/// <param name="antibodyTypeId">Antibody type ID</param>
		/// <returns>List of blood units</returns>
		public static DataTable GetBloodUnitsWithAntibodyType(int antibodyTypeId)
		{
			return StoredProcedure.GetDataTable( 
				STOREDPROC.GetBloodUnitsByAntiBodyTypeId.StoredProcName,
				StoredProcedure.MakeParameter( STOREDPROC.GetBloodUnitsByAntiBodyTypeId.antibodytypeid, antibodyTypeId ),
				StoredProcedure.MakeParameter( STOREDPROC.GetBloodUnitsByAntiBodyTypeId.divisioncode, Common.LogonUser.LogonUserDivisionCode )
				);
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1153"> 
		///		<ExpectedInput>The data table containing antibodies</ExpectedInput>
		///		<ExpectedOutput>True</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1881"> 
		///		<ExpectedInput>Invalid data table</ExpectedInput>
		///		<ExpectedOutput>Exception</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Saves a data table of antibody types to database
		/// </summary>
		/// <param name="dtAntibodies">Datatable containing list of antibodies to save</param>
		/// <returns>Returns true on success; otherwise - false</returns>
		public static bool SaveAntibodyTypes( DataTable dtAntibodies )
		{
			return( new StoredProcedure().TransactionalGetValue( STOREDPROC.UpdateAntibodyTypes.StoredProcName,dtAntibodies ) == 0 );
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="2213"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataTable of AntigenTest</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="792"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Returns a DataTable representing the AntigenTest reference table.
		/// </summary>
		/// <returns></returns>
		public static DataTable GetAntigenTest()
		{
			return StoredProcedure.GetDataTable( STOREDPROC.GetAntigenTest.StoredProcName );
		}


		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7320"> 
		///		<ExpectedInput>AntigenTypeId</ExpectedInput>
		///		<ExpectedOutput>DataTable with rows</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="7321"> 
		///		<ExpectedInput>Invalid AntigenTypeId</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetAntibodiesForAntigenType
		/// </summary>
		/// <param name="antigenTypeId"></param>
		/// <returns></returns>
		public static DataTable GetAntibodiesForAntigenType(int antigenTypeId)
		{
			return StoredProcedure.GetDataTable(STOREDPROC.GetAntibodiesForAntigenType.StoredProcName,StoredProcedure.MakeParameter( STOREDPROC.GetAntibodiesForAntigenType.antigentypeid, antigenTypeId ));
		}
	}
}



